<?php
defined('ABSPATH') || exit;
global $product;
$product_id = $product->get_id();
$p_sold = dejavo_product_percent_sold();
?>
<div class="dej_var_product product-card card-4">
    <div class="image">
        <?php dej_product_labels($product_id, dej_opt('show_dej_icon_label', 1));
        dejavo_simple_star_rating(); ?>
        <a href="<?php the_permalink(); ?>"><?php dejavo_product_box_image() ?></a>
        <?php dejavo_variation() ?>
    </div>
    <div class="info">
        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        <div class="list-icon">
            <div class="plus">
                <?php echo sprintf('<a aria-label="%s" href="%s" data-quantity="1" class="add-to-cart hint--top-left %s" %s><i class="dej-shopping-cart"></i></a>',
                    esc_html($product->add_to_cart_text()),
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        '', 'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                    )))),
                    wc_implode_html_attributes(array(
                        'data-product_id' => $product_id,
                        'data-product_sku' => $product->get_sku(),
                        'aria-label' => $product->add_to_cart_description(),
                        'rel' => 'nofollow',
                    ))
                );
                ?>

                <ul class="icons">
                    <?php if (class_exists('DejavoWL')) { ?>
                        <li class="hint--top"
                            aria-label="<?php _e('علاقه مندی', 'dejavo') ?>"><?= DejavoWL::wl_btn($product_id) ?></li>
                    <?php }
                    if (class_exists('DejavoCP')) { ?>
                        <li class="hint--top"
                            aria-label="<?php _e('مقایسه', 'dejavo') ?>"><?= DejavoCP::cp_btn($product_id) ?></li>
                    <?php }
                    if (class_exists('DejavoQV')) { ?>
                        <li class="hint--top-right"
                            aria-label="<?php _e('نمایش سریع', 'dejavo') ?>"><?= DejavoQV::qv_btn($product_id) ?></li><?php } ?>
                </ul>
            </div>
            <div class="price-box">
                <?php woocommerce_template_loop_price();
                if ($product->is_on_sale()) {
                    woocommerce_show_product_sale_flash();
                } ?>
            </div>
        </div>
        <div class="product_sale">
            <?php if (!is_null($p_sold)) { ?><div class="sale_bar">
                <div class="sale_bar_amount" style="width:<?= $p_sold ?>%;" aria-valuenow="<?= $p_sold ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div><?php } ?>
            <div class="percent_sold">
                <div class="percent"><?php if (!is_null($p_sold)) { ?>
                        <span><?= $p_sold . '%' ?></span><?= __('فروخته شده', 'dejavo') ?><?php } ?></div>
                <?php if (dejavo_contdown_timer()) { ?>
                <div class="countdown_time2" data-times="<?= dejavo_contdown_timer(); ?>"></div><?php } ?>
            </div>
        </div>
    </div>
</div>