<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$force_login = false;

if (!is_user_logged_in() and dej_opt('dej_auth') and (dej_opt('dej_auth_checkout') || $checkout->is_registration_required())) {

    $style = '<style> .woocommerce-checkout .dej_login_form {display: flex; height: auto;} </style>';
    echo $style;
    echo '<div class="dej_checkout_just_login">' . esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) ) . '</div>';

    DejavoAuth::AuthForm(true);

    return;
} elseif ( !is_user_logged_in()  and $checkout->is_registration_required() ) {
    echo '<div class="dej_checkout_just_login">' . esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) ) . '</div>';
    woocommerce_login_form();
} else {
do_action( 'woocommerce_before_checkout_form', $checkout );

?>

<form name="checkout" method="post" class="dej_checkout checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

    <div class="inner">
	<?php if ( $checkout->get_checkout_fields() ) : ?>
        <div class="dej_checkout_form" id="customer_details">
		<?php
        do_action( 'woocommerce_checkout_before_customer_details' );
        do_action( 'woocommerce_checkout_billing' );
        do_action( 'woocommerce_checkout_shipping' );
        do_action( 'woocommerce_checkout_after_customer_details' ); ?>
        </div>
	<?php endif; ?>

    <div class="dej_payment_review">
	
	<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
	
	<h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'woocommerce' ); ?></h3>
	
	<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

	<div id="order_review" class="woocommerce-checkout-review-order">
		<?php do_action( 'woocommerce_checkout_order_review' ); ?>
	</div>
	<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

    </div>
    </div>

</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout );
}?>
