<?php
/**
 * Show options for ordering
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/orderby.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$id_suffix = wp_unique_id();

$opt_names = [
        'popularity' =>  __( 'محبوبیت', 'dejavo' ),
        'rating' =>  __( 'امتیاز', 'dejavo' ),
        'date' =>  __( 'آخرین', 'dejavo' ),
        'price' =>  __( 'ارزانترین', 'dejavo' ),
        'price-desc' =>  __( 'گرانترین', 'dejavo' ),
        'relevance' =>  __( 'شباهت', 'dejavo' ),
        'menu_order' =>  __( 'پیشفرض', 'dejavo' ),
    ];

if (!dej_is_mobile()) {
?>
<form class="woocommerce-ordering" method="get">
	<ul name="orderby" class="orderby dej_orderby" aria-label="<?php esc_attr_e( 'Shop order', 'woocommerce' ); ?>">
		<?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
			<li class="<?php echo esc_attr( $id ); if ($orderby ==$id) {echo ' selected';} ?>"
                <?php selected( $orderby, $id ); ?>>
                <a href="<?php echo dejavo_shop_page_url() . '?orderby=' . esc_attr( $id ); ?>"><?=  $opt_names[$id] ?></a>
                </li>
		<?php  endforeach; ?>
	</ul>
	<input type="hidden" name="paged" value="1" />
	<?php wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) ); ?>
</form>
<?php } else {   ?>

    <form class="woocommerce-ordering" method="get">
        <?php if ( $use_label ) : ?>
            <label for="woocommerce-orderby-<?php echo esc_attr( $id_suffix ); ?>"><?php echo esc_html__( 'Sort by', 'woocommerce' ); ?></label>
        <?php endif; ?>
        <select
                name="orderby"
                class="orderby"
            <?php if ( $use_label ) : ?>
                id="woocommerce-orderby-<?php echo esc_attr( $id_suffix ); ?>"
            <?php else : ?>
                aria-label="<?php esc_attr_e( 'Shop order', 'woocommerce' ); ?>"
            <?php endif; ?>
        >
            <?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
                <option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
            <?php endforeach; ?>
        </select>
        <input type="hidden" name="paged" value="1" />
        <?php wc_query_string_form_fields( null, array( 'orderby', 'submit', 'paged', 'product-page' ) ); ?>
    </form>
<?php } ?>
<div class="shop_sidebar_btn"><i class="dej-filter"></i> <?= __( 'فیلتر', 'dejavo' ); ?></div>










