<?php
/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined('ABSPATH') || exit;

/**
 * My Account navigation.
 *
 * @since 2.6.0
 */

$user = wp_get_current_user();
$user_id = get_current_user_id();

function dejavo_number_of_register_days(): int
{
    $user_id = get_current_user_id();
    $customer = new WC_Customer($user_id);
    $date_from = $customer->get_date_created('Y-m-d');
    $date_now = date('Y-m-d');
    return intval((strtotime($date_now) - strtotime($date_from)) / (60 * 60 * 24)) ?? 0;
}

$notifications = dej_opt('dej_notifications') ?? 0;
$alert = '';
if (is_array($notifications)) {
    $alert = '<div class="alert"></div>';
}
?>
<div class="dej_profile">
    <div class="dej_profile_header">

        <div class="dej_user_info">
            <div class="avatar"><?= get_avatar($user_id, 120); ?></div>
            <div class="info">
                <span class="name"><a href="<?= wc_customer_edit_account_url() ?>"><?= $user->display_name; ?></a></span>
                <span class="days"><?php echo __('عضویت از', 'dejavo') . ' ' . dejavo_number_of_register_days() . ' ' . __('روز پیش', 'dejavo'); ?></span>
                <?php if (  class_exists( 'WooWallet' ) ) { ?><span class="wallet"><?php echo __('کیف پول :', 'dejavo') . ' ' . woo_wallet()->wallet->get_wallet_balance( get_current_user_id() ); ?></span> <?php }  ?>
            </div>

        </div>
        <ul class="dej_header_profile_nav">
            <li class="profile_sidebar_btn"><a href="#"><i class="dej-menu-burger"></i></a></li>
            <li class="mob_hide"><a href="<?= get_home_url() ?>"><i class="dej-home"></i></a></li>
            <li><a href="<?= get_permalink( wc_get_page_id( 'shop' ) ) ?>"><i class="dej-shop"></i></a></li>
            <li class="mob_hide"><a href="<?= wc_get_cart_url() ?>"><i class="dej-shopping-bag"></i></a></li>
            <?php if (dej_opt('dej_show_notifications')) { ?><li><a class="notifications" href="<?= wc_get_account_endpoint_url('notes')?>"><i class="dej-bell"></i><?= $alert ?></a></li> <?php } ?>
            <li><a href="<?= wc_logout_url() ?>"><i class="dej-sign-out"></i></a></li>
        </ul>


    </div>
    <div class="dej_profile_wrapper">

        <?php do_action('woocommerce_account_navigation'); ?>

        <div class="woocommerce-MyAccount-content">
            <?php
            /**
             * My Account content.
             *
             * @since 2.6.0
             */
            do_action('woocommerce_account_content');
            ?>
        </div>

    </div>
</div>
