<?php

defined('ABSPATH') || exit;
global $product;
if (!comments_open()) {
    return;
}
?>

<div class="dejavo_advanced_reviews">
    <div class="right">
        <div id="reviews" class="woocommerce-Reviews">

            <div id="comments">
                <h4 class="woocommerce-Reviews-title">
                    <?php
                    $count = $product->get_review_count();
                    if ($count && wc_review_ratings_enabled()) {
                        /* translators: 1: reviews count 2: product name */
                        $reviews_title = sprintf(esc_html(_n('%1$s review for %2$s', '%1$s reviews for %2$s', $count, 'woocommerce')), esc_html($count), '<span>' . get_the_title() . '</span>');
                        echo apply_filters('woocommerce_reviews_title', $reviews_title, $count, $product); // WPCS: XSS ok.
                    } else {
                        esc_html_e('Reviews', 'woocommerce');
                    }
                    ?>
                </h4>

                <?php if (have_comments()) : ?>

                    <ol class="commentlist">
                        <?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
                    </ol>

                    <?php
                    if (get_comment_pages_count() > 1 && get_option('page_comments')) :
                        echo '<nav class="woocommerce-pagination">';
                        paginate_comments_links(
                            apply_filters(
                                'woocommerce_comment_pagination_args',
                                array(
                                    'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
                                    'next_text' => is_rtl() ? '&larr;' : '&rarr;',
                                    'type' => 'list',
                                )
                            )
                        );
                        echo '</nav>';
                    endif;
                    ?>
                    <?php else : ?>
                        <p class="woocommerce-noreviews"><?php esc_html_e('There are no reviews yet.', 'woocommerce'); ?></p>
                    <?php endif; ?>
            </div>

            <div class="clear"></div>
        </div>
        <?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())) { ?>
            <div id="review_form_wrapper">
                <div id="review_form">
                    <?php if ( dej_opt('show_dej_reviews_slide_opt', 1) and comments_open()) { ?>
                        <script data-no-optimize="1" src="<?php bloginfo('template_url'); ?>/assets/libs/nouislider/nouislider.min.js"></script>
                        <link data-no-optimize="1" href="<?php bloginfo('template_url'); ?>/assets/libs/nouislider/nouislider.min.css" rel="stylesheet">
                    <?php
                    $slider_rating = dej_opt('dej_slider_rating');
                    if (!$slider_rating) {return;}
                    $counter = 0;
                    foreach ($slider_rating as $item) {
                    $key = 'dejavo_rate' . $counter; ?>
                        <div class="dejavo_ratings">
                            <span class="title"><?= $item['dej_slide_rate'] ?></span>
                            <div class="dejavo_rate">
                                <div class="dejavo-nouislider">
                                    <div id="<?= $key ?>"></div>
                                </div>
                                <div class="options">
                        <span class="dejavo_rating_option tag-dejavo_rate<?= $counter ?>" number-label="1"
                              style="display: none;"><?php _e('خیلی بد', 'dejavo'); ?></span>
                                    <span class="dejavo_rating_option tag-dejavo_rate<?= $counter ?>" number-label="2"
                                          style=""><?php _e('بد', 'dejavo'); ?></span>
                                    <span class="dejavo_rating_option tag-dejavo_rate<?= $counter ?>" style="display: none;"
                                          number-label="3"><?php _e('معمولی', 'dejavo'); ?></span>
                                    <span class="dejavo_rating_option tag-dejavo_rate<?= $counter ?>" number-label="4"
                                          style="display: none;"><?php _e('خوب', 'dejavo'); ?></span>
                                    <span class="dejavo_rating_option tag-dejavo_rate<?= $counter ?>" number-label="5"
                                          style="display: none;"><?php _e('عالی', 'dejavo'); ?></span>
                                </div>
                            </div>
                        </div>
                        <script>
                            var <?= $key ?> = document.getElementById('<?= $key ?>');
                            noUiSlider.create(<?= $key ?>, {
                                direction: 'rtl', connect: [true, false], start: 3, step: 1,
                                format: {to: (v) => parseFloat(v).toFixed(0), from: (v) => parseFloat(v).toFixed(0)},
                                range: {min: 1, max: 5}
                            });
                            <?= $key ?>.noUiSlider.on('update', function (value) {
                                jQuery(".<?= $key ?>").val(value[0]);
                                jQuery(".tag-<?= $key ?>").hide(0);
                                jQuery(".tag-<?= $key ?>[number-label=" + value[0] + "]").show(0);
                            });
                        </script>
                        <?php
                        $counter++;
                    }
                    }

                    $commenter = wp_get_current_commenter();
                    $comment_form = array(
                        /* translators: %s is product title */
                        'title_reply' => '',
                        /* translators: %s is product title */
                        'title_reply_to' => esc_html__('Leave a Reply to %s', 'woocommerce'),
                        'title_reply_before' => '<span id="reply-title" class="comment-reply-title">',
                        'title_reply_after' => '</span>',
                        'comment_notes_after' => '',
                        'class_submit' => 'dejavo_btn',
                        'submit_field' => '%1$s %2$s',
                        'label_submit' => esc_html__('Submit', 'woocommerce'),
                        'logged_in_as' => '',
                        'comment_field' => '',
                        'class_form' => 'dej_comment_form',
                        'submit_button' => '<button id="%2$s" class="%3$s"  value="%4$s" type="submit">' . esc_html__('Submit', 'woocommerce') . '</button>'
                    );

                    $name_email_required = (bool)get_option('require_name_email', 1);

                    $fields = array(
                        'author' => array(
                            'label' => __('Name', 'woocommerce'),
                            'type' => 'text',
                            'value' => $commenter['comment_author'],
                            'required' => $name_email_required,
                        ),
                        'email' => array(
                            'label' => __('Email', 'woocommerce'),
                            'type' => 'email',
                            'value' => $commenter['comment_author_email'],
                            'required' => $name_email_required,
                        ),
                    );

                    $comment_form['fields'] = array();


                    foreach ($fields as $key => $field) {
                        $field_html = '';
                        if ($key == 'author') {
                            $field_html .= '<div class="dej_inputs">';
                        }

                        $field_html .= '<input class="dej_input" placeholder="' . esc_html($field['label']);
                        if ($field['required']) {
                            $field_html .= ' * ';
                        }
                        $field_html .= ' " id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" value="' . esc_attr($field['value']) . '"  ' . ($field['required'] ? 'required' : '') . ' />';

                        if ($key == 'email') {
                            $field_html .= '</div>';
                        }

                        $comment_form['fields'][$key] = $field_html;
                    }


                    $account_page_url = wc_get_page_permalink('myaccount');
                    if ($account_page_url) {
                        /* translators: %s opening and closing link tags respectively */
                        $comment_form['must_log_in'] = '<div class="must-log-in"><i class="dej-lock"></i> <div class="text">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</div></div>';
                    }


                    if (wc_review_ratings_enabled()) {
                        $comment_form['comment_field'] = '<div class="comment-form-rating"><label for="rating">' . esc_html__('Your rating', 'woocommerce') . (wc_review_ratings_required() ? '&nbsp;<span class="required">*</span>' : '') . '</label><select name="rating" id="rating">
						<option value="">' . esc_html__('Rate&hellip;', 'woocommerce') . '</option>
						<option value="5">' . esc_html__('Perfect', 'woocommerce') . '</option>
						<option value="4">' . esc_html__('Good', 'woocommerce') . '</option>
						<option value="3">' . esc_html__('Average', 'woocommerce') . '</option>
						<option value="2">' . esc_html__('Not that bad', 'woocommerce') . '</option>
						<option value="1">' . esc_html__('Very poor', 'woocommerce') . '</option>
					</select></div>';
                    }
                    if (dej_opt('show_dej_reviews_recommend', true)) {
                        $comment_form['comment_field'] .= '<div class="dejavo-recommend-product-reveiw">';
                        $comment_form['comment_field'] .= '<span>' . esc_html__('آیا خرید این محصول را به دوستانتان پیشنهاد می کنید؟', 'dejavo') . '</span>';
                        $comment_form['comment_field'] .= '<label for="recommended"><input id="recommended" type="radio" value="recommended" name="recommend" /><div class="text"><i class="dej-thumbs-up"></i> ' . esc_html__('پیشنهاد می‌کنم', 'dejavo') . '</div></label>';
                        $comment_form['comment_field'] .= '<label for="not_recommended"><input id="not_recommended" type="radio" value="not_recommended" name="recommend" /><div class="text"><i class="dej-thumbs-down"></i> ' . esc_html__('پیشنهاد نمی‌کنم', 'dejavo') . '</div></label>';
                        $comment_form['comment_field'] .= '<label for="no_idea"><input id="no_idea" type="radio" value="no_idea" name="recommend" /><div class="text"><i class="dej-meh"></i> ' . esc_html__('نظری ندارم', 'dejavo') . '</div></label>';
                        $comment_form['comment_field'] .= '</div>';
                    }
                    if (dej_opt('show_dej_reviews_advantage', true)) {
                        $comment_form['comment_field'] .= '<div class="dejavo-comment-advantages">';
                        $comment_form['comment_field'] .= '<p class="dejavo-input-comment-form comment-form-advantages"><span class="add_text_to_field add_text_to_field_advantages">افزودن</span>';
                        $comment_form['comment_field'] .= '<input id="comment-form-advantages" placeholder="' . __('نقاط قوت', 'dejavo') . '" type="text" value="" size="30" /></p>';
                        $comment_form['comment_field'] .= '<p class="dejavo-input-comment-form comment-form-disadvantage"><span class="add_text_to_field add_text_to_field_disadvantage">افزودن</span>';
                        $comment_form['comment_field'] .= '<input id="comment-form-disadvantage" placeholder="' . __('نقاط ضعف', 'dejavo') . '" type="text" value="" size="30" /></p>';
                        $comment_form['comment_field'] .= '</div>';
                    }


                    if (dej_opt('show_dej_reviews_slide_opt', true) and dej_opt('dej_slider_rating')) {

                        $slider_rating = dej_opt('dej_slider_rating');
                        $counter = 0;
                        foreach ($slider_rating as $item) {
                            $key = 'dejavo_rate' . $counter;
                            $comment_form['comment_field'] .= '<input name="' . esc_attr($key) . '" class="' . esc_attr($key) . '" type="hidden" value="3" >';
                            $counter++;
                        }
                    }


                    $comment_form['comment_field'] .= '<textarea  placeholder="' . esc_html__('Your review', 'woocommerce') . ' * " class="dej_input dej_textarea" id="comment" name="comment" cols="45"  rows="7" required></textarea>';

                    comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
                    ?>
                </div>
            </div>
        <?php } else { ?>
            <p class="woocommerce-verification-required"><?php esc_html_e('Only logged in customers who have purchased this product may leave a review.', 'woocommerce'); ?></p>
        <?php } ?>
    </div>
    <div class="left">
        <?php if (dej_opt('show_dej_reviews_slide_opt', 1) ) {
            global $product;
            $product_id =$product->get_id();
            ?>
            <div class="display_dejavo_ratings_product">
                <div class="title">
                    <span><?php echo '<strong>' . __('ارزیابی کاربران از', 'dejavo') . '</strong> " ' . $product->get_title() . ' "' ?></span> <?php dejavo_star_rating(); ?>
                </div>
                <div class="image"><?php echo get_the_post_thumbnail($product->get_id(), 'thumbnail') ?></div>
            </div>
            <div class="display_dejavo_ratings">
                <?php
                $slider_rating = dej_opt('dej_slider_rating', 0);
                if (!$slider_rating) {return;}
                $counter = $average = $count = $percent = 0;
                foreach ($slider_rating as $item) {
                    $key = 'dejavo_rate' . $counter;
                    $average = get_average_option_rating($product_id, $key);
                    $count = get_count_option_rating($product_id, $key);
                    $percent = $average * 20;
                    ?>
                    <div class="display_dejavo_rate">
                        <?php
                        echo '<div class="title_sec"> <span>' . $item['dej_slide_rate'] . ' (' . $average . '  از 5 )</span> <span class="comment_count">' . $count . ' نظر</span></div>';
                        echo '<div class="dejavo_progres"><div class="bar" style="width:' . $percent . '%"  aria-valuenow="' . $percent . '" aria-valuemin="0" aria-valuemax="100"></div></div>';
                        ?>
                    </div>
                    <?php
                    $counter++;
                } ?>
            </div>
            <?php
        }

        ?>
    </div>
</div>
<style type="text/css" data-no-optimize="1">
    .noUi-connect {
        background: var(--dej-color1);
    }

    .noUi-target {
        background: #e7e6e6;
    }

    .noUi-horizontal {
        height: 7px;
        cursor: pointer;
        border: 0;
    }

    .noUi-horizontal .noUi-handle {
        width: 15px;
        height: 15px;
        border-radius: 5px;
    }

    .noUi-horizontal .noUi-handle {
        top: -4px;
    }

    .noUi-txt-dir-rtl.noUi-horizontal .noUi-handle {
        left: -14px;
        transition: transform 0.3s;
        cursor: pointer;
    }

    .dejavo_rate:hover .noUi-handle {
        transform: scale(1.15);
    }

    .noUi-handle:after, .noUi-handle:before {
        content: unset;
    }

    .noUi-handle {
        border: 0;
        border-radius: 6px;
        background: var(--dej-color1);
        box-shadow: unset;
    }

    .dejavo_rate .dejavo-nouislider {
        width: 82%;
    }

    .dejavo_rate .options {
        width: 18%;
        display: flex;
        justify-content: flex-end;
    }

</style>
<?php if (dej_opt('show_dej_reviews_advantage', true)) { ?>
    <script>
        jQuery(document).ready(function ($) {
            var inputs = $('input#comment-form-advantages, input#comment-form-disadvantage');
            var inputChangeCallback = function () {
                var self = $(this);
                if (self.val().trim().length > 0) {
                    self.siblings('.add_text_to_field').show();
                } else {
                    self.siblings('.add_text_to_field').hide();
                }
            };
            inputs.each(function () {
                inputChangeCallback.bind(this)();
                $(this).on('change keyup', inputChangeCallback.bind(this));
            });

            $('.add_text_to_field_advantages').on('click', function () {

                var val_item = $(this).parent().find('input#comment-form-advantages').val();
                if (val_item.trim().length < 3) {

                    return;
                }
                $(this).parent().append(' <span class="item_added_advantages" > <input type="hidden" name="advantages[]" value="' + val_item.trim() + '" > ' + val_item.trim() + ' <span class="remove_item dejavo-add"></span></span> ');
                $(this).parent().find('input#comment-form-advantages').val('');

                $(this).hide(0);
            });

            $('.add_text_to_field_disadvantage').on('click', function () {

                var val_item = $(this).parent().find('input#comment-form-disadvantage').val();
                if (val_item.trim().length < 3) {

                    return;
                }
                $(this).parent().append(' <span class="item_added_disadvantage" > <input type="hidden" name="disadvantage[]" value="' + val_item.trim() + '" > ' + val_item.trim() + ' <span class="remove_item  dejavo-add"></span></span> ');
                $(this).parent().find('input#comment-form-disadvantage').val('');

                $(this).hide(0);
            });
            $('body').on('click', 'span.remove_item', function () {
                $(this).parent().remove();
            });
        });
    </script>
<?php } ?>



