<?php


defined('ABSPATH') || exit;

if (!$product_attributes) {
    return;
}

$divider = '<br>';
global $post, $product;
$has_row = true;
$alt = 1;
$alt2 = 1;
$attributes = $product->get_attributes();

$args = array('posts_per_page' => -1, 'post_type' => 'attribute_group', 'post_status' => 'publish', 'orderby' => 'menu_order', 'suppress_filters' => 0);

$attr_groups = get_posts($args);

$attrs = $haveGroup = [];

if (!empty($attr_groups)) {
    foreach ($attr_groups as $attr_group) {
        $attr_group_name = $attr_group->post_title;
        $attr_group_id = $attr_group->ID;
        $attributeGroupIcon = get_post_meta($attr_group->ID, 'woocommerce_group_attributes_icon', true);
        $icon = "";
        if (!empty($attributeGroupIcon)) {
            $icon = '<i class="' . $attributeGroupIcon . ' attr-cat-icon"></i>';
        } else {
            $icon = '<i class="dej-angle-small-left attr-cat-icon"></i>';
        }

        $attributes_in_groups = get_post_meta($attr_group->ID, 'woocommerce_group_attributes_attributes');

        if (is_array($attributes_in_groups[0])) {
            $attributes_in_groups = $attributes_in_groups[0];
        }


        if (!empty($attributes_in_groups)) {
            foreach ($attributes_in_groups as $attribute_in_group) {


                $attribute_in_group = wc_get_attribute($attribute_in_group);


                foreach ($attributes as $attribute) {

                    if ($attribute['visible'] == 0) {
                        continue;
                    }

                    if (is_object($attribute_in_group) && $attribute_in_group->id == $attribute['id']) {
                        unset($attributes[$attribute['name']]);
                        $attrs[$attr_group_id]['name'] = $attr_group_name;
                        $attrs[$attr_group_id]['icon'] = $icon;
                        $attrs[$attr_group_id]['attributes'][] = $attribute;
                        $haveGroup[] = $attribute['id'];

                    } else {
                        $attrs[$attribute['name']] = $attribute;
                    }
                }
            }
        }
    }
} else {
    $attrs = $attributes;
}

foreach ($attrs as $attr) {

    if (is_array($attr)) {
        continue;
    }
    $id = 0;
    if (is_object($attr)){
        $id = $attr->get_id();
    }

    if (!in_array($id, $haveGroup)) {
        $attrs['other']['name'] = __('سایر مشخصات', 'dejavo');
        $attrs['other']['icon'] = '<i class="dej-angle-small-left attribute-group-icon"></i>';
        $attrs['other']['attributes'][] = $attr;
    }
    unset($attrs[$id]);
}
ob_start();

?>
<div class="dej_attr">

<?php if ($product->has_weight()) { ?>
    <div class="attr_row attr_weight">
        <div class="attr_name_values">
            <div class="<?php if (($alt = $alt * -1) == 1) echo 'odd'; ?>">
                <div class="attr_name"><?php _e('Weight', 'woocommerce') ?></div>
                <div class="attr_value product_weight"><?php echo esc_html(wc_format_weight($product->get_weight())); ?></div>
            </div>
        </div>
    </div>
<?php }
if ($product->has_dimensions()) { ?>
    <div class="attr_row attr_dimensions">
        <div class="attr_name_values">
            <div class="<?php if (($alt = $alt * -1) == 1) echo 'odd'; ?>">
                <div class="attr_name"><?php _e('Dimensions', 'woocommerce') ?></div>
                <div class="attr_value product_dimensions"><?php echo esc_html(wc_format_dimensions($product->get_dimensions(false))); ?></div>
            </div>
        </div>
    </div>
<?php }



foreach ($attrs as $key => $attr_group) {
    $alt = 1;

    if (is_array($attr_group) and isset($attr_group['attributes'])) {
        ?>
        <?php
        echo '<div class="attr_cat_name">';
        if (isset($attr_group['icon']) && !empty($attr_group['icon'])) {
            echo $attr_group['icon'];
        }

        if (isset($attr_group['name']) && !empty($attr_group['name'])) {
            echo $attr_group['name'];
        }
        echo '</div>';
    }

    if (!is_array($attr_group['attributes']) || (is_array($attr_group['attributes']) and count($attr_group['attributes']) === 0 ) ) {
        continue;
    }

    ksort($attr_group['attributes']);
    echo '<div class="attr_row attr_row_list">';

    foreach ($attr_group['attributes'] as $attribute) {
        echo '<div class="attr_name_values">';

        if (empty($attribute['visible']) || !isset($attribute['name']) ) {
            continue;
        } else {
            $has_row = true;
        }

        if (($alt = $alt * -1) == 1) {
            echo ' <div class="odd">';
        } else {
            echo ' <div>';
        }
        $hasImage = apply_filters('woocommerce_attribute_name_image', wc_attribute_label($attribute->get_name()), $attribute->get_id());
        if ($hasImage) {
            $attribute_name = $hasImage;
        } else {
            $attribute_name = wc_attribute_label($attribute->get_name());
        }
        echo '<div class="attr_name">' . esc_attr($attribute_name) . '</div>';
        echo '<div class="attr_value">';
        $values = [];

        if ($attribute->is_taxonomy()) {
            $attribute_taxonomy = $attribute->get_taxonomy_object();
            $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));

            foreach ($attribute_values as $attribute_value) {

                $hasImage = apply_filters('woocommerce_attribute_value_image', esc_html($attribute_value->name), $attribute_value->term_id);
                if (!empty($hasImage)) {
                    $value_name = $hasImage;
                } else {
                    $value_name = esc_html($attribute_value->name);
                }

                if ($attribute_taxonomy->attribute_public) {
                    $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                } else {
                    $values[] = $value_name;
                }
            }
        } else {
            $values = $attribute->get_options();

            foreach ($values as &$value) {
                $value = make_clickable(esc_html($value));
            }
        }
        echo apply_filters('woocommerce_attribute', wpautop(wptexturize(implode($divider, $values))), $attribute, $values);
        echo '</div></div></div>';
    }
    echo '</div>';
}
echo '</div>';
echo ob_get_clean();

