<?php
/**
 * The template to display the reviewers meta data (name, verified owner, review date)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review-meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

global $comment;
$verified = wc_review_is_from_verified_owner( $comment->comment_ID );

if ( '0' === $comment->comment_approved ) { ?>

	<p class="meta">
		<em class="woocommerce-review__awaiting-approval">
			<?php esc_html_e( 'Your review is awaiting approval', 'woocommerce' ); ?>
		</em>
	</p>

<?php } else { ?>

	<p class="meta">
		<strong class="woocommerce-review__author"><?php comment_author(); ?> </strong>
		<?php
		if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) && $verified ) {
			echo '<em class="woocommerce-review__verified verified">(' . esc_attr__( 'verified owner', 'woocommerce' ) . ')</em> ';
		}

		?>
		<span class="woocommerce-review__dash">&ndash;</span> <time class="woocommerce-review__published-date" datetime="<?php echo esc_attr( get_comment_date( 'c' ) ); ?>"><?php echo esc_html( get_comment_date( wc_date_format() ) ); ?></time>

        <?php if ( dej_opt('show_dej_reviews_recommend', 1) ) {
        global $comment;
        $recommend = get_comment_meta($comment->comment_ID, 'recommend', true);
        if (!empty($recommend)) {
            if ($recommend == "recommended") {
                $rec_label = __('پیشنهاد می‌کنم', 'dejavo');
                echo '<em class="review_recommend dejavo_reveiw_' . $recommend . '" >
		<i class="dej-thumbs-up"></i>
			' . $rec_label . '
			</em>';

            } elseif ($recommend == "no_idea") {
                $rec_label = __('مطمئن نیستم', 'dejavo');
                echo '<em class="review_recommend dejavo_reveiw_' . $recommend . '" >
<i class="dej-meh"></i>
			' . $rec_label . '
			</em>';

            } elseif ($recommend == "not_recommended") {
                $rec_label = __('پیشنهاد نمی‌کنم', 'dejavo');
                echo '<em class="review_recommend dejavo_reveiw_' . $recommend . '" >
			<i class="dej-thumbs-down"></i>
			' . $rec_label . '
			</em>';

            }
        }
    } ?>
	</p>

	<?php
}
